/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.p.service.managedsystem.fru;

import com.ibm.hwmca.fw.pa.system.PASystem;
import com.ibm.hwmca.fw.service.config.ClassData;
import com.ibm.hwmca.fw.service.config.ClassUtils;
import com.ibm.hwmca.fw.service.managedsystem.ServiceableElement;
import com.ibm.hwmca.fw.service.managedsystem.ServiceableElementFilter;
import com.ibm.hwmca.fw.service.managedsystem.fru.Fru;
import com.ibm.hwmca.fw.service.managedsystem.fru.config.EnclosureConfigEntry;
import com.ibm.hwmca.fw.service.managedsystem.fru.config.FruTableEntry;
import com.ibm.hwmca.fw.service.managedsystem.persist.ServiceableElementPersistenceException;
import com.ibm.hwmca.fw.service.serviceaction.ServiceActionType;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.p.pa.fru.PIFru;
import com.ibm.hwmca.xfw.pa.fru.CommonPaFru;
import com.ibm.hwmca.xfw.service.managedsystem.fru.DefaultFruFilter;
import com.ibm.hwmca.xfw.service.managedsystem.fru.DefaultFruPersistence;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class PIFruPersistence
extends DefaultFruPersistence {
    private static final String TRACE_MASKT = "XRVPIFPT";
    private static final String TRACE_MASKF = "XRVPIPFF";
    private static final String TRACE_MASKD = "XRVPIFPD";
    private static final String INFO_CENTER_FRU = "com.ibm.hwmca.xfw.service.managedsystem.fru.InfoCenterFru";
    private static final String PROCEDURE_ENCLOSURE_KEY = "PROC|FEATURE_CODE";
    private static final String[][] REPLACEMENT_PRIORITIES = new String[][]{{"H", "G"}, {"M", "I"}, {"A", "G"}, {"B", "G"}, {"C", "G"}, {"L", "I"}};

    public List load(ServiceableElementFilter filter) throws ServiceableElementPersistenceException {
        Trace.trace(TRACE_MASKT, "-> PIFruPersistence load for filter[" + filter + "]");
        if (!this.initDone) {
            throw new ServiceableElementPersistenceException("PIFruPersistence.init method not called, or failed");
        }
        AbstractList returnList = null;
        if (filter instanceof DefaultFruFilter) {
            List passedFrus = ((DefaultFruFilter)filter).getFruList();
            if (passedFrus != null) {
                HashMap<String, LinkedList> groupMap = new HashMap<String, LinkedList>();
                returnList = new ArrayList();
                Iterator it = passedFrus.iterator();
                ServiceableElement currentFru = null;
                Integer currentFruFlags = new Integer(0);
                while (it.hasNext()) {
                    ArrayList locationCodes;
                    Integer fruFlags;
                    CommonPaFru pafru = (CommonPaFru)it.next();
                    PASystem pas = pafru.getEnclosureSystem();
                    FruTableEntry fte = null;
                    String fruid = pafru.getId();
                    if (fruid == null) {
                        Trace.trace(TRACE_MASKF, "PIFruPersistence.load Fru ID not set in CommonPaFru[" + pafru + "]");
                    } else {
                        Trace.trace(TRACE_MASKF, "PIFruPersistence.load looking for a specific FRU id[" + fruid + "]");
                    }
                    String enclosureType = pas.getMachineType();
                    if (enclosureType == null) {
                        Trace.trace(TRACE_MASKT, "<-! PIFruPersistence.load enclosureType not set in CommonPaFru[" + pafru + "]");
                        throw new ServiceableElementPersistenceException("enclosureType not set in CommonPaFru[" + pafru + "]");
                    }
                    Trace.trace(TRACE_MASKF, "PIFruPersistence.load looking for enclosure type[" + enclosureType + "]");
                    String enclosureModel = pas.getMachineModel();
                    if (enclosureModel == null) {
                        Trace.trace(TRACE_MASKT, "<-! PIFruPersistence.load enclosureModel not set in CommonPaFru[" + pafru + "]");
                        throw new ServiceableElementPersistenceException("enclosureModel not set in CommonPaFru[" + pafru + "]");
                    }
                    Trace.trace(TRACE_MASKF, "PIFruPersistence.load looking for enclosure model[" + enclosureModel + "]");
                    String enclosureSerial = pas.getMachineSerial();
                    if (enclosureSerial == null) {
                        Trace.trace(TRACE_MASKT, "<-! PIFruPersistence.load enclosureSerial not set in CommonPaFru[" + pafru + "]");
                        throw new ServiceableElementPersistenceException("enclosureSerial not set in CommonPaFru[" + pafru + "]");
                    }
                    Trace.trace(TRACE_MASKF, "PIFruPersistence.load looking for enclosure serial[" + enclosureSerial + "]");
                    if (pafru instanceof PIFru) {
                        int ff = ((PIFru)pafru).getFruClass();
                        if (ff == 0) {
                            Trace.trace(TRACE_MASKF, "PIFruPersistence.load overriding PIFru.CLASS_RESERVED0 setting with PIFru.CLASS_FRU");
                            ff = 1;
                        }
                        fruFlags = new Integer(ff);
                    } else {
                        fruFlags = new Integer(1);
                    }
                    Trace.trace(TRACE_MASKF, "PIFruPersistence.load FRU flags[" + fruFlags + "]");
                    String partNumber = pafru.getPartNumber();
                    Trace.trace(TRACE_MASKF, "PIFruPersistence.load FRU part number[" + partNumber + "]");
                    if (partNumber != null) {
                        partNumber = partNumber.trim();
                        int i = partNumber.indexOf(95);
                        while (i != -1) {
                            String first = "";
                            if (i != 0) {
                                first = partNumber.substring(0, i);
                            }
                            String next = "";
                            if (i != partNumber.length() - 1) {
                                next = partNumber.substring(i + 1);
                            }
                            partNumber = first + next;
                            i = partNumber.indexOf(95);
                        }
                    }
                    String locationCode = null;
                    String[] secondaryLocs = null;
                    if (fruFlags != 1) {
                        if (currentFru != null && currentFruFlags == 1 && partNumber != null && partNumber.equals("CBLCONT")) {
                            int aii;
                            Trace.trace(TRACE_MASKF, "PIFruPersistence.load processing CBLCONT fru...");
                            locationCodes = pafru.getLocationList();
                            if (locationCodes == null) continue;
                            int newlocsSize = locationCodes.size();
                            int arrayOffset = 0;
                            Map props = currentFru.getProperties();
                            String[] currentSecondaryLocations = (String[])props.get("SECONDARY_LOCATIONS");
                            if (currentSecondaryLocations == null) {
                                currentSecondaryLocations = new String[newlocsSize];
                            } else {
                                String[] newArray = new String[currentSecondaryLocations.length + newlocsSize];
                                aii = 0;
                                while (aii < currentSecondaryLocations.length) {
                                    newArray[aii] = currentSecondaryLocations[aii];
                                    ++aii;
                                }
                                arrayOffset = aii;
                                currentSecondaryLocations = newArray;
                            }
                            Object[] newLocations = locationCodes.toArray();
                            aii = 0;
                            while (aii < newlocsSize) {
                                Trace.trace(TRACE_MASKF, "PIFruPersistence.load processing CBLCONT fru: adding additional location:" + (String)newLocations[aii]);
                                currentSecondaryLocations[arrayOffset + aii] = (String)newLocations[aii];
                                ++aii;
                            }
                            currentFru.putProperty("SECONDARY_LOCATIONS", currentSecondaryLocations);
                            continue;
                        }
                        if (partNumber == null || partNumber.length() == 0) continue;
                        Trace.trace(TRACE_MASKF, "PIFruPersistence.load non-Hardware FRU resolution, partNumber: " + partNumber);
                        EnclosureConfigEntry procedureEnclosure = (EnclosureConfigEntry)this.fruTableMap.get(PROCEDURE_ENCLOSURE_KEY);
                        if (procedureEnclosure != null) {
                            Trace.trace(TRACE_MASKF, "PIFruPersistence.load PROC enclosure defined in FRU table for type|model (" + enclosureType + "|" + enclosureModel + ")");
                            Map procedureseMap = procedureEnclosure.getLocations();
                            Object[] proceduresArray = (Object[])procedureseMap.get(partNumber);
                            if (proceduresArray != null) {
                                Trace.trace(TRACE_MASKF, "PIFruPersistence.load procedure IS defined in FRU table");
                                fte = (FruTableEntry)proceduresArray[0];
                            } else {
                                Trace.trace(TRACE_MASKF, "PIFruPersistence.load procedure is NOT defined in FRU table");
                            }
                        }
                        if (fte == null) {
                            fte = new FruTableEntry();
                            ClassData symfrucd = new ClassData();
                            symfrucd.setClassName(INFO_CENTER_FRU);
                            fte.setClassData(symfrucd);
                        }
                        locationCode = partNumber;
                        Trace.trace(TRACE_MASKF, "PIFruPersistence.load non-Hardware FRU - location code set to partnum[" + locationCode + "]");
                    } else {
                        locationCodes = pafru.getLocationList();
                        if (locationCodes == null || locationCodes.size() == 0) {
                            Trace.trace(TRACE_MASKF, "PIFruPersistence.load CLASS_FRU fru with NO location code?  ...ignorning and skipping...");
                            continue;
                        }
                        locationCode = (String)locationCodes.get(0);
                        String[] enclMTMS = PIFruPersistence.parseEnclosureInfo(locationCode);
                        enclosureType = enclMTMS[0];
                        enclosureModel = enclMTMS[1];
                        enclosureSerial = enclMTMS[2];
                        Trace.trace(TRACE_MASKT, "PIFruPersistence.load overriding enclosure MTMS from FRU location code: enclosureType[" + enclosureType + "],enclosureModel[" + enclosureModel + "],enclosureSerial[" + enclosureSerial + "]");
                        if (locationCodes.size() > 1) {
                            secondaryLocs = new String[locationCodes.size() - 1];
                            int aii = 0;
                            while (aii < locationCodes.size() - 1) {
                                secondaryLocs[aii] = (String)locationCodes.get(aii + 1);
                                ++aii;
                            }
                        }
                        boolean doingEnclosure = false;
                        if (locationCode.indexOf(45) == -1) {
                            Trace.trace(TRACE_MASKF, "PIFruPersistence.load resolving enclosure location: " + locationCode);
                            doingEnclosure = true;
                        }
                        if (locationCode == null) {
                            Trace.trace(TRACE_MASKT, "<-! PIFruPersistence.load no location code for CommonPaFru[" + pafru + "]");
                            throw new ServiceableElementPersistenceException("no location code for CommonPaFru[" + pafru + "]");
                        }
                        Trace.trace(TRACE_MASKF, "PIFruPersistence.load looking for FRU location code[" + locationCode + "]");
                        String enclosureKey = enclosureType.toUpperCase() + "|" + enclosureModel.toUpperCase();
                        fte = null;
                        if (!this.fruTableMap.containsKey(enclosureKey) && !this.fruTableMap.containsKey(enclosureKey = enclosureType.toUpperCase() + "|" + "FEATURE_CODE")) {
                            Trace.trace(TRACE_MASKT, "!!! PIFruPersistence.load the Fru table for machine type[" + this.machineType + "],model[" + this.machineModel + "] doesn't define the enclosure type[" + enclosureType + "],model[" + enclosureModel + "] - using InfoCenterFru");
                            Map userData = filter.getUserData();
                            fte = userData != null && (((String)userData.get("rvType")).equals(ServiceActionType.POWER_OFF.getValue()) || ((String)userData.get("rvType")).equals(ServiceActionType.POWER_ON.getValue())) && locationCode.indexOf(45) == -1 ? this.makeUnknownButPowerableEnclosureFte() : this.makeUnknownFruFte();
                        }
                        if (fte == null) {
                            EnclosureConfigEntry ece = (EnclosureConfigEntry)this.fruTableMap.get(enclosureKey);
                            Map locationCodeMap = ece.getLocations();
                            Object[] possibleFrusAtLocationArray = (Object[])locationCodeMap.get(DefaultFruPersistence.getLocationCodeSuffix(locationCode));
                            if (possibleFrusAtLocationArray == null && !doingEnclosure) {
                                Trace.trace(TRACE_MASKF, "!!! PIFruPersistence.load the location[" + locationCode + "] is not defined for the enclosure type[" + enclosureType + "],model[" + enclosureModel + "] - Using FRU class type InfoCenterFru");
                                fte = this.makeUnknownFruFte();
                            } else {
                                FruTableEntry defaultEntry = null;
                                if (!doingEnclosure) {
                                    int aii = 0;
                                    while (aii < possibleFrusAtLocationArray.length) {
                                        if (possibleFrusAtLocationArray[aii] instanceof FruTableEntry) {
                                            fte = (FruTableEntry)possibleFrusAtLocationArray[aii];
                                            if (defaultEntry == null && fte.getId() == null) {
                                                defaultEntry = fte;
                                                Trace.trace(TRACE_MASKF, "PIFruPersistence.load located default FRU table definition");
                                            }
                                            if (fruid != null && fruid.equals(fte.getId())) {
                                                Trace.trace(TRACE_MASKF, "PIFruPersistence.load located FRU table entry with matching id");
                                                break;
                                            }
                                            Trace.trace(TRACE_MASKF, "PIFruPersistence.load id mismatch - using default FRU table entry for location");
                                            fte = defaultEntry;
                                        }
                                        ++aii;
                                    }
                                } else {
                                    fte = new FruTableEntry();
                                    fte.setClassData(ece.getClassData());
                                    fte.setPowerBoundary(true);
                                }
                            }
                        }
                    }
                    if (fte == null) {
                        Trace.trace(TRACE_MASKF, "PIFruPersistence.load FRU resolution failed: location[" + locationCode + "],fruid[" + fruid + "],enclosureType[" + enclosureType + "],enclosureModel[" + enclosureModel + "]. Using InfoCenterFru class");
                        fte = this.makeUnknownFruFte();
                    }
                    boolean done = false;
                    int aii = 0;
                    while (aii < 2 && !done) {
                        try {
                            LinkedList groupll;
                            String groupId;
                            HashMap<String, String> fruProps;
                            Fru fru = (Fru)ClassUtils.instantiate(fte.getClassData());
                            currentFru = fru;
                            currentFruFlags = fruFlags;
                            Map fteProps = fte.getProperties();
                            if (fteProps != null) {
                                fruProps = fru.getProperties();
                                if (fruProps != null) {
                                    fruProps.putAll(fteProps);
                                    fru.setProperties(fruProps);
                                } else {
                                    fru.setProperties(fteProps);
                                }
                            }
                            if ((fruProps = fru.getProperties()) == null) {
                                fruProps = new HashMap<String, String>();
                            }
                            fruProps.put("LOCATION", locationCode);
                            fruProps.put("ENCLOSURE_TYPE", enclosureType);
                            fruProps.put("ENCLOSURE_MODEL", enclosureModel);
                            fruProps.put("ENCLOSURE_SERIAL", enclosureSerial);
                            fruProps.put("FLAGS", (String)((Object)fruFlags));
                            fruProps.put("PART_NUM", partNumber);
                            if (secondaryLocs != null) {
                                fruProps.put("SECONDARY_LOCATIONS", (String)secondaryLocs);
                            }
                            fruProps.put("MANAGED_SYSTEM_TYPE", this.machineType);
                            fruProps.put("MANAGED_SYSTEM_MODEL", this.machineModel);
                            fruProps.put("POWER_BOUNDARY_IS_FRU", (String)((Object)(fte.isPowerBoundary() ? Boolean.TRUE : Boolean.FALSE)));
                            fru.setProperties(fruProps);
                            if (pafru instanceof PIFru) {
                                PIFru pifru = (PIFru)pafru;
                                groupId = pifru.getReplacementGroup();
                                if (groupId == null || groupId.length() == 0) {
                                    groupId = "M";
                                }
                            } else {
                                groupId = "M";
                            }
                            fruProps.put("GROUP_ID", groupId);
                            if (groupMap.containsKey(groupId)) {
                                groupll = (LinkedList)groupMap.get(groupId);
                            } else {
                                groupll = new LinkedList();
                                groupMap.put(groupId, groupll);
                            }
                            Trace.trace(TRACE_MASKF, "PIFruPersistence.load FRU at location[" + locationCode + "] added to replacement group[" + groupId + "]");
                            groupll.addLast(fru);
                            done = true;
                        }
                        catch (Exception e) {
                            Trace.trace(TRACE_MASKF, "!!! PIFruPersistence.load exception caught instantiating class: " + fte.getClassData());
                            Trace.trace(TRACE_MASKF, e);
                            Trace.trace(TRACE_MASKF, "...retrying with class InfoCenterFru...");
                            fte = this.makeUnknownFruFte();
                        }
                        ++aii;
                    }
                }
                int blockid = 0;
                int aii = 0;
                while (aii < REPLACEMENT_PRIORITIES.length) {
                    LinkedList frusByGroup;
                    if (groupMap.containsKey(REPLACEMENT_PRIORITIES[aii][0]) && (frusByGroup = (LinkedList)groupMap.get(REPLACEMENT_PRIORITIES[aii][0])) != null) {
                        Iterator fit = frusByGroup.iterator();
                        boolean needToIncrementBlockid = false;
                        while (fit.hasNext()) {
                            ServiceableElement se = (ServiceableElement)fit.next();
                            if (REPLACEMENT_PRIORITIES[aii][1].equals("G")) {
                                se.putProperty("EXCHANGE_BLOCK", new Integer(blockid));
                                needToIncrementBlockid = true;
                                continue;
                            }
                            se.putProperty("EXCHANGE_BLOCK", new Integer(blockid));
                            ++blockid;
                        }
                        if (needToIncrementBlockid) {
                            ++blockid;
                        }
                        if (returnList == null) {
                            returnList = frusByGroup;
                        } else {
                            returnList.addAll(returnList.size(), frusByGroup);
                        }
                    }
                    ++aii;
                }
            }
        } else {
            Trace.trace(TRACE_MASKT, "<-! PIFruPersistence.load unsupported filter[" + filter + "]");
            throw new ServiceableElementPersistenceException("unsupported filter :" + filter);
        }
        PIFruPersistence.displayResolvedFruList(returnList);
        Trace.trace(TRACE_MASKT, "<- PIFruPersistence load, number of frus resolved: " + (returnList == null ? "0" : String.valueOf(returnList.size())));
        return returnList;
    }

    private static void displayResolvedFruList(List returnFruList) {
        String debugoutput = "";
        if (returnFruList != null) {
            Iterator it = returnFruList.iterator();
            while (it.hasNext()) {
                ServiceableElement se = (ServiceableElement)it.next();
                debugoutput = se != null ? debugoutput + se.getClass().getName() + "|" + se.getProperties() + "\n" : debugoutput + "null ??? | null???\n";
            }
        } else {
            debugoutput = "no FRUs resolved (null)";
        }
        Trace.trace(TRACE_MASKF, "PIFruPersistence.displayResolvedFruList: start...\n" + debugoutput + " ...end");
    }

    private static String[] parseEnclosureInfo(String locationCode) {
        String[] enclMTMS = new String[3];
        int firstDot = locationCode.indexOf(46);
        int nextDot = locationCode.indexOf(46, firstDot + 1);
        int dash = locationCode.indexOf(45);
        enclMTMS[0] = locationCode.substring(1, firstDot);
        enclMTMS[1] = locationCode.substring(firstDot + 1, nextDot);
        enclMTMS[2] = dash == -1 ? locationCode.substring(nextDot + 1) : locationCode.substring(nextDot + 1, dash);
        return enclMTMS;
    }

    protected FruTableEntry makeUnknownFruFte() {
        FruTableEntry fte = new FruTableEntry();
        ClassData unknownfrucd = new ClassData();
        unknownfrucd.setClassName(INFO_CENTER_FRU);
        fte.setClassData(unknownfrucd);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("EXCHANGE_PROCEDURE", "iphau/removereplace.htm");
        props.put("VERIFY_PROCEDURE", "iphau/endcall.htm");
        fte.setProperties(props);
        return fte;
    }

    protected FruTableEntry makeUnknownButPowerableEnclosureFte() {
        FruTableEntry fte = new FruTableEntry();
        ClassData unknownenc = new ClassData();
        unknownenc.setClassName("com.ibm.hwmca.p.service.io.mantis.fru.MantisEnclosure");
        fte.setClassData(unknownenc);
        fte.setPowerBoundary(true);
        return fte;
    }
}

